SUBROUTINE G_CALCULATE_OPTICAL_PROPERTIES &
    (NLAY, NCOMP, ML, SPECIESFLAG, LWP, G_LWP, RMM, G_RMM, MOLECTAU, &
     G_MOLECTAU, TAURAYL, G_TAURAYL, SRCTYPE, SOLARMU, NOUT, MUOUT, PHIOUT, &
     TAUP, G_TAUP, ALBEDOP, G_ALBEDOP, LEGENP, G_LEGENP, SSPHASE, G_SSPHASE, &
     NSCATTAB, SPECIES2TABLE, MAXNR, NRTAB, RTAB, EXTINCTTAB, SSALBTAB, &
     MAXLEG, NLEGTAB, LEGENTAB)
  IMPLICIT NONE
  INTEGER :: NLAY, NCOMP, ML, NOUT, MAXNR, NSCATTAB, NRTAB(NSCATTAB)
  INTEGER :: MAXLEG, SPECIES2TABLE(NCOMP), NLEGTAB(MAXNR,NSCATTAB)
  LOGICAL :: SPECIESFLAG(NCOMP,NLAY) 
  REAL    :: LWP(NCOMP,NLAY), G_LWP(NCOMP,NLAY)
  REAL    :: RMM(NCOMP,NLAY), G_RMM(NCOMP,NLAY)
  REAL    :: MOLECTAU(NLAY), G_MOLECTAU(NLAY), TAURAYL(NLAY), G_TAURAYL(NLAY)
  REAL    :: SOLARMU, MUOUT, PHIOUT
  REAL    :: TAUP(NLAY), G_TAUP(NLAY), ALBEDOP(NLAY), G_ALBEDOP(NLAY)
  REAL    :: LEGENP(1:ML+1,NLAY), G_LEGENP(1:ML+1,NLAY)
  REAL    :: SSPHASE(NLAY,NOUT), G_SSPHASE(NLAY,NOUT)
  REAL    :: RTAB(MAXNR,NSCATTAB), EXTINCTTAB(MAXNR,NSCATTAB)
  REAL    :: SSALBTAB(MAXNR,NSCATTAB), LEGENTAB(1:MAXLEG,MAXNR,NSCATTAB)
  CHARACTER*(1) :: SRCTYPE

  PRINT *, 'SHDOMPPDA tangent linear is unavailable'
  STOP
END SUBROUTINE G_CALCULATE_OPTICAL_PROPERTIES



SUBROUTINE G_SOLVE_FIXED_SHDOMPP2 &
     (NLAY, TEMPP, G_TEMPP, TAUP, G_TAUP, ALBEDOP, G_ALBEDOP, &
      LEGENP, G_LEGENP, SSPHASE, G_SSPHASE, NPTS, FRACTAUG, IXP, SHSOURCE, &
      ML, MM, NLM, NMU, NPHI, NPHI0MAX, SRCTYPE, SOLARFLUX, SOLARMU, &
      WAVELEN, WAVENO, SKYRAD, SFCTEMP, G_SFCTEMP, SFCTYPE, &
      SFCPARMS, G_SFCPARMS, NMOREITER, ACCELPAR, NOUT, MUOUT, PHIOUT, &
      RADOUT, G_RADOUT)
  IMPLICIT NONE
  INTEGER :: NLAY, NPTS, IXP(2,NLAY)
  INTEGER :: ML, MM, NLM, NMU, NPHI, NPHI0MAX, NMOREITER, NOUT
  REAL    :: TEMPP(NLAY+1), G_TEMPP(NLAY+1), TAUP(NLAY), G_TAUP(NLAY)
  REAL    :: ALBEDOP(NLAY), G_ALBEDOP(NLAY)
  REAL    :: LEGENP(1:ML+1,NLAY), G_LEGENP(1:ML+1,NLAY)
  REAL    :: SSPHASE(NLAY,NOUT), G_SSPHASE(NLAY,NOUT)
  REAL    :: FRACTAUG(NPTS),  SHSOURCE(NLM,NPTS), SOLARFLUX, SOLARMU
  REAL    :: WAVELEN, WAVENO(2), SKYRAD, SFCTEMP, G_SFCTEMP
  REAL    :: SFCPARMS(*), G_SFCPARMS(*), ACCELPAR(NMOREITER)
  REAL    :: MUOUT(NOUT), PHIOUT(NOUT), RADOUT(NOUT), G_RADOUT(NOUT)
  CHARACTER*(1) :: SRCTYPE, SFCTYPE

  PRINT *, 'SHDOMPPDA tangent linear is unavailable'
  STOP
END SUBROUTINE G_SOLVE_FIXED_SHDOMPP2

